% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats_tidiers.R
\name{tidy.dist}
\alias{tidy.dist}
\title{Tidy a distance matrix}
\usage{
\method{tidy}{dist}(x, diag = attr(x, "Diag"), upper = attr(x, "Upper"),
  ...)
}
\arguments{
\item{x}{A "dist" object}

\item{diag}{Whether to include the diagonal of the distance
matrix. Defaults to whether the distance matrix includes it}

\item{upper}{Whether to include the upper right triangle of
the distance matrix. Defaults to whether the distance matrix
includes it}

\item{...}{Extra arguments, not used}
}
\value{
A data frame with one row for each pair of
item distances, with columns:
\describe{
  \item{item1}{First item}
  \item{item2}{Second item}
  \item{distance}{Distance between items}
}
}
\description{
Tidy a distance matrix, such as that computed by the \link{dist}
function, into a one-row-per-pair table. If the distance matrix
does not include an upper triangle and/or diagonal, this will
not either.
}
\examples{

iris_dist <- dist(t(iris[, 1:4]))
iris_dist

tidy(iris_dist)
tidy(iris_dist, upper = TRUE)
tidy(iris_dist, diag = TRUE)

}

