% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/zoo_tidiers.R
\name{zoo_tidiers}
\alias{tidy.zoo}
\alias{zoo_tidiers}
\title{Tidying methods for a zoo object}
\usage{
\method{tidy}{zoo}(x, ...)
}
\arguments{
\item{x}{An object of class \code{"zoo"}}

\item{...}{extra arguments (not used)}
}
\value{
\code{tidy} returns a data frame with one row for each observation
in each series, with the following columns:
  \item{index}{Index (usually date) for the zoo object}
  \item{series}{Name of the series}
  \item{value}{Value of the observation}
}
\description{
Tidies \code{zoo} (Z's ordered observations) time series objects.
\code{zoo} objects are not tidy by default because they contain one row
for each index and one series per column, rather than one row per
observation per series.
}
\examples{
if (require("zoo", quietly = TRUE)) {
    set.seed(1071)

    # data generated as shown in the zoo vignette
    Z.index <- as.Date(sample(12450:12500, 10))
    Z.data <- matrix(rnorm(30), ncol = 3)
    colnames(Z.data) <- c("Aa", "Bb", "Cc")
    Z <- zoo(Z.data, Z.index)

    tidy(Z)

    if (require("ggplot2", quietly = TRUE)) {
        ggplot(tidy(Z), aes(index, value, color = series)) + geom_line()
        ggplot(tidy(Z), aes(index, value)) + geom_line() +
            facet_wrap(~ series, ncol = 1)

        Zrolled <- rollmean(Z, 5)
        ggplot(tidy(Zrolled), aes(index, value, color = series)) + geom_line()
    }
}
}

