% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ridgelm_tidiers.R
\name{ridgelm_tidiers}
\alias{glance.ridgelm}
\alias{ridgelm_tidiers}
\alias{tidy.ridgelm}
\title{Tidying methods for ridgelm objects from the MASS package}
\usage{
\method{tidy}{ridgelm}(x, ...)

\method{glance}{ridgelm}(x, ...)
}
\arguments{
\item{x}{An object of class "ridgelm"}

\item{...}{extra arguments (not used)}
}
\value{
All tidying methods return a \code{data.frame} without rownames.
The structure depends on the method chosen.

\code{tidy.ridgelm} returns one row for each combination of
choice of lambda and term in the formula, with columns:
  \item{lambda}{choice of lambda}
  \item{GCV}{generalized cross validation value for this lambda}
  \item{term}{the term in the ridge regression model being estimated}
  \item{estimate}{estimate of coefficient using this lambda}

\code{glance.ridgelm} returns a one-row data.frame with the columns
  \item{kHKB}{modified HKB estimate of the ridge constant}
  \item{kLW}{modified L-W estimate of the ridge constant}
  \item{lambdaGCV}{choice of lambda that minimizes GCV}

This is similar to the output of \code{select.ridgelm}, but it is returned
rather than printed.
}
\description{
These methods tidies the coefficients of a ridge regression model
chosen at each value of lambda into a data frame, or constructs
a one-row glance of the model's choices of lambda (the ridge
constant)
}
\examples{
names(longley)[1] <- "y"
fit1 <- MASS::lm.ridge(y ~ ., longley)
tidy(fit1)

fit2 <- MASS::lm.ridge(y ~ ., longley, lambda = seq(0.001, .05, .001))
td2 <- tidy(fit2)
g2 <- glance(fit2)

# coefficient plot
library(ggplot2)
ggplot(td2, aes(lambda, estimate, color = term)) + geom_line()

# GCV plot
ggplot(td2, aes(lambda, GCV)) + geom_line()

# add line for the GCV minimizing estimate
ggplot(td2, aes(lambda, GCV)) + geom_line() +
    geom_vline(xintercept = g2$lambdaGCV, col = "red", lty = 2)
}

