% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_list_contrasts.R
\name{model_list_contrasts}
\alias{model_list_contrasts}
\alias{model_list_contrasts.default}
\title{List contrasts used by a model}
\usage{
model_list_contrasts(model)

\method{model_list_contrasts}{default}(model)
}
\arguments{
\item{model}{a model object}
}
\value{
A tibble with three columns:
\itemize{
\item \code{variable}: variable name
\item \code{contrasts}: contrasts used
\item \code{contrasts_type}: type of contrasts
("treatment", "sum", "poly", "helmert" or "other")
\item \code{reference}: for variables with treatment, SAS
or sum contrasts, position of the reference level
}
}
\description{
List contrasts used by a model
}
\examples{
glm(
  am ~ mpg + factor(cyl),
  data = mtcars,
  family = binomial,
  contrasts = list(`factor(cyl)` = contr.sum)
) \%>\%
  model_list_contrasts()
}
\seealso{
Other model_helpers: 
\code{\link{model_get_coefficients_type}()},
\code{\link{model_get_contrasts}()},
\code{\link{model_get_model_frame}()},
\code{\link{model_get_model_matrix}()},
\code{\link{model_get_model}()},
\code{\link{model_get_nlevels}()},
\code{\link{model_get_xlevels}()},
\code{\link{model_identify_variables}()},
\code{\link{model_list_terms_levels}()},
\code{\link{model_list_variables}()}
}
\concept{model_helpers}
