% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_list_terms_levels.R
\name{model_list_terms_levels}
\alias{model_list_terms_levels}
\alias{model_list_terms_levels.default}
\title{List levels of categorical terms}
\usage{
model_list_terms_levels(model)

\method{model_list_terms_levels}{default}(model)
}
\arguments{
\item{model}{a model object}
}
\value{
A tibble with four columns:
\itemize{
\item \code{variable}: variable
\item \code{term}: term name
\item \code{level}: term level
\item \code{reference}: logical indicating which term is the reference level
}
}
\description{
Only for categorical variables with treatment,
SAS or sum contrasts.
}
\examples{
glm(
  am ~ mpg + factor(cyl),
  data = mtcars,
  family = binomial,
  contrasts = list(`factor(cyl)` = contr.sum)
) \%>\%
  model_list_terms_levels()

df <- Titanic \%>\%
  dplyr::as_tibble() \%>\%
  dplyr::mutate(Survived = factor(Survived, c("No", "Yes")))

df \%>\%
  glm(
    Survived ~ Class + Age + Sex,
    data = ., weights = .$n, family = binomial,
    contrasts = list(Age = contr.sum, Class = "contr.helmert")
  ) \%>\%
  model_list_terms_levels()
}
\seealso{
Other model_helpers: 
\code{\link{model_get_contrasts}()},
\code{\link{model_get_model_frame}()},
\code{\link{model_get_model_matrix}()},
\code{\link{model_get_xlevels}()},
\code{\link{model_identify_variables}()},
\code{\link{model_list_contrasts}()},
\code{\link{model_list_variables}()}
}
\concept{model_helpers}
