% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keys_near.R
\name{keys_near.data.frame}
\alias{keys_near.data.frame}
\title{Return keys nearest to a given statistics or summary.}
\usage{
\method{keys_near}{data.frame}(.data, key, var, top_n = 1, funs = l_five_num, ...)
}
\arguments{
\item{.data}{data.frame}

\item{key}{key, which identifies unique observations.}

\item{var}{variable to summarise}

\item{top_n}{top number of closest observations to return - default is 1, which will also return ties.}

\item{funs}{named list of functions to summarise by. Default is a given
list of the five number summary, \code{l_five_num}.}

\item{...}{extra arguments to pass to \code{mutate_at} when performing the summary
as given by \code{funs}.}
}
\description{
Return keys nearest to a given statistics or summary.
}
\examples{
heights \%>\%
  key_slope(height_cm ~ year) \%>\%
  keys_near(key = country,
            var = .slope_year)
# Specify your own list of summaries
l_ranges <- list(min = b_min,
                 range_diff = b_range_diff,
                 max = b_max,
                 iqr = b_iqr)

heights \%>\%
  key_slope(formula = height_cm ~ year) \%>\%
  keys_near(key = country,
              var = .slope_year,
              funs = l_ranges)
}
