% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brokenstick-class.R
\name{brokenstick-class}
\alias{brokenstick-class}
\title{Class \code{brokenstick}}
\description{
The main fitting function \code{\link[=brokenstick]{brokenstick()}} returns an object of class
\code{brokenstick}. This object collects the fitted broken stick model.
}
\details{
The package exports S3 methods for the \code{brokenstick} class for the following
generic functions: \code{\link[=coef]{coef()}}, \code{\link[=fitted]{fitted()}}, \code{\link[=model.frame]{model.frame()}}, \code{\link[=model.matrix]{model.matrix()}},
\code{\link[=plot]{plot()}}, \code{\link[=predict]{predict()}}, \code{\link[=print]{print()}}, \code{\link[=residuals]{residuals()}} and \code{\link[=summary]{summary()}}.

The package exports the following helper functions for \code{brokenstick} objects:
\code{\link[=get_knots]{get_knots()}}, \code{\link[=get_omega]{get_omega()}} and \code{\link[=get_r2]{get_r2()}}.

A \code{brokenstick} object is a list with the following named elements:
}
\section{Elements}{

\describe{
\item{\code{call}}{Call that created the object}
\item{\code{names}}{A named list with three elements (\code{"x"}, \code{"y"}, \code{"g"})
providing the variable name for time, outcome and subject, respectively.}
\item{\code{internal}}{Numeric vector of with internal knots.}
\item{\code{boundary}}{Numeric vector of length 2 with the boundary knots.}
\item{\code{degree}}{The \code{degree} of the B-spline. See \code{\link[splines:bs]{splines::bs()}}. Support
only the values of 0 (step model) or 1 (broken stick model).}
\item{\code{method}}{String, either \code{"kr"} or \code{"lmer"}, identifying the fitting model.}
\item{\code{control}}{List of control options returned by \code{\link[=set_control]{set_control()}} used
to set algorithmic details.}
\item{\code{beta}}{Numeric vector with fixed effect estimates.}
\item{\code{omega}}{Numeric matrix with variance-covariance estimates of the
broken stick estimates.}
\item{\code{sigma2}}{Numeric scalar with the mean residual variance.}
\item{\code{sample}}{A numeric vector with descriptives of the training data.}
\item{\code{light}}{Should the returned object be lighter? If \code{light = TRUE}
the returned object will contain only the model settings and parameter
estimates and not store the \code{sigma2j}, \code{sample}, \code{data}, \code{imp} and
\code{mod} elements.
The light object can be used to predict broken stick estimates for
new data, but does not disclose the training data and is small.}
\item{\code{sigma2j}}{Numeric vector with estimates of the residual variance per
group. Only used by method \code{"kr"}.}
\item{\code{data}}{The training data used to fit the model.}
\item{\code{imp}}{The imputations generated for the missing outcome data. Only
for \code{method = "kr"}.}
\item{\code{mod}}{For \code{method = "kr"}: A named list with four components, each of
class \link[coda:mcmc]{coda::mcmc}. For \code{method = "lmer"}: An object of class
\link[lme4:merMod-class]{lme4::merMod}.}
}
}

\references{
van Buuren S (2021).
Broken Stick Model for Irregular Longitudinal Data. \emph{In preparation}.
}
\author{
Stef van Buuren, 2021
}
