# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Integrate over Multivariate Normal Random Effects
#'
#' Used in the process of Monte Carlo integration
#' over multivariate normal random effects. This generates the
#' random draws from the multivariate normal distribution
#' and multiplies these by the data.
#' Not intended to be called directly by most users.
#'
#' @param X A numeric matrix of the data to be multiplied by the random effects
#' @param k An integer, the number of random samples to be used for numerical integration
#' @param sd A numeric vector of the standard deviations
#' @param chol A numeric matrix, which should be the Cholesky decomposition of the
#'   correlation matrix of the multivariate normal distribution.
#' @return A numeric matrix with random values
#' @export
#' @examples
#' integratemvn(
#'   X = matrix(1, 1, 2),
#'   k = 100L,
#'   sd = c(10, 5),
#'   chol = chol(matrix(c(1, .5, .5, 1), 2)))
#' 
#' integratemvn(matrix(1, 1, 1), 100L, c(5), matrix(1))
integratemvn <- function(X, k, sd, chol) {
    .Call(`_brmsmargins_integratemvn`, X, k, sd, chol)
}

#' Integrate over Random Effects
#'
#' Used to conduct Monte Carlo integration over Gaussian random effects.
#' Not intended to be called directly by most users.
#'
#' @param d A list with model matrices for each random effect block.
#' @param sd A list with standard deviation matrices for each random effect block
#'   where rows are different posterior draws.
#' @param L A list with matrices for each random effect block containing the parts of
#'   the L matrix, the Cholesky decomposition of the random effect correlation matrix.
#' @param k An integer, the number of samples for Monte Carlo integration.
#' @param yhat A matrix of the fixed effects predictions
#' @param backtrans An integer, indicating the type of back transformation.
#'   0 indicates inverse logit (e.g., for logistic regression).
#'   1 indicates exponential (e.g., for poisson or negative binomial regression or if outcome was natural log transformed).
#'   2 indicates square (e.g., if outcome was square root transformed).
#'   Any other integer may be used for no transformation.
#' @return A numeric matrix with the Monte Carlo integral calculated.
#' @export
#' @examples
#' integratere(
#'   d = list(matrix(1, 1, 1)),
#'   sd = list(matrix(1, 2, 1)),
#'   L = list(matrix(1, 2, 1)),
#'   k = 10L,
#'   yhat = matrix(0, 2, 1),
#'   backtrans = 0L)
integratere <- function(d, sd, L, k, yhat, backtrans) {
    .Call(`_brmsmargins_integratere`, d, sd, L, k, yhat, backtrans)
}

#' Bootstrap Row Means
#'
#' This takes a numeric matrix, bootstrap resamples each row, and then
#' calculates the mean. The intended use case is for Bayesian posterior
#' predictions from sample data. Instead of directly calculating the
#' average marginal effect (AME) across all observed values, these can be
#' bootstrapped, so that uncertainty in the target population, and thus
#' the AME in the target population, can be incorporated.
#' Model uncertainty is already assumed to be handled by the different posterior
#' samples, which are assumed to be across rows.
#' 
#' @param x A numeric matrix 
#' @return A numeric vector with the simple bootstrapped row means of the matrix
#' @export
#' @examples
#'
#' x <- matrix(1:9, byrow = TRUE, 3)
#' replicate(10, rowBootMeans(x))
rowBootMeans <- function(x) {
    .Call(`_brmsmargins_rowBootMeans`, x)
}

#' Convert a Row of a Table to a Square Matrix
#'
#' Utility function to convert a row matrix to a square matrix.
#' Used as the \code{brms} package returns things like the Cholesky
#' decomposition matrix as separate columns where rows are posterior draws.
#' Not intended to be called directly by most users.
#'
#' @param X a matrix
#' @return A numeric matrix with one row.
#' @export
#' @examples
#' tab2mat(matrix(1:4, 1))
#' tab2mat(matrix(1:9, 1))
tab2mat <- function(X) {
    .Call(`_brmsmargins_tab2mat`, X)
}

