% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/s3.correlations.R
\name{cor.ar}
\alias{cor.ar}
\title{AR(p) correlation structure}
\usage{
cor.ar(formula = ~1, p = 1)
}
\arguments{
\item{formula}{A one sided formula of the form ~ t, or ~ t | g, specifying a time covariate t and, optionally, a grouping factor g.
A covariate for this correlation structure must be integer valued. When a grouping factor is present in \code{formula}, the correlation structure
is assumed to apply only to observations within the same grouping level; observations with different grouping levels are assumed to be uncorrelated.
Defaults to ~ 1, which corresponds to using the order of the observations in the data as a covariate, and no groups.}

\item{p}{A non-negative integer specifying the autoregressive order of the ARMA structure. Default is 1.}
}
\value{
An object of class \code{cor.arma} containing solely autoregression terms.
}
\description{
This function is a constructor for the \code{cor.arma} class, allowing for autoregression terms only.
}
\examples{
cor.ar(~visit|patient, p = 2)
}
\author{
Paul-Christian Buerkner \email{paul.buerkner@gmail.com}
}
\seealso{
\code{\link{cor.arma}}
}

