% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brm_plot_compare.R
\name{brm_plot_compare}
\alias{brm_plot_compare}
\title{Visually compare the marginals of models and datasets.}
\usage{
brm_plot_compare(..., marginal = "response")
}
\arguments{
\item{...}{Named data frames of marginals posterior summaries
from \code{\link[=brm_marginal_summaries]{brm_marginal_summaries()}} and/or \code{\link[=brm_marginal_data]{brm_marginal_data()}}.}

\item{marginal}{Character of length 1, which kind of marginal
to visualize: either \code{"response"}, \code{"change"}, or \code{"difference"}.
Only applies to MCMC output, the data is always on the scale of the
response variable.}
}
\value{
A \code{ggplot} object.
}
\description{
Visually compare the marginals of models and datasets.
}
\examples{
if (identical(Sys.getenv("BRM_EXAMPLES", unset = ""), "true")) {
set.seed(0L)
data <- brm_data(
  data = brm_simulate()$data,
  outcome = "response",
  role = "response",
  group = "group",
  time = "time",
  patient = "patient"
)
formula <- brm_formula(
  data = data,
  effect_base = FALSE,
  interaction_base = FALSE
)
tmp <- utils::capture.output(
  suppressMessages(
    suppressWarnings(
      model <- brm_model(
        data = data,
        formula = formula,
        chains = 1,
        iter = 100,
        refresh = 0
      )
    )
  )
)
draws <- brm_marginal_draws(
  model = model,
  data = data,
  control = "group 1",
  baseline = "time 1"
)
suppressWarnings(summaries_draws <- brm_marginal_summaries(draws))
summaries_data <- brm_marginal_data(data)
brm_plot_compare(
  model1 = summaries_draws,
  model2 = summaries_draws,
  data = summaries_data
)
brm_plot_compare(
  model1 = summaries_draws,
  model2 = summaries_draws,
  marginal = "difference"
)
}
}
\seealso{
Other visualization: 
\code{\link{brm_plot_draws}()}
}
\concept{visualization}
