% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brm_marginal_summaries.R
\name{brm_marginal_summaries}
\alias{brm_marginal_summaries}
\title{Summary statistics of the marginal posterior of an MMRM.}
\usage{
brm_marginal_summaries(draws, level = 0.95)
}
\arguments{
\item{draws}{Posterior draws of the marginal posterior
obtained from \code{\link[=brm_marginal_draws]{brm_marginal_draws()}}.}

\item{level}{Numeric of length 1 between 0 and 1, credible level
for the credible intervals.}
}
\value{
A tibble with one row per summary statistic and the following
columns:
\itemize{
\item \code{marginal}: type of marginal distribution. If \code{outcome} was \code{"response"}
in \code{\link[=brm_marginal_draws]{brm_marginal_draws()}}, then possible values include
\code{"response"} for the response on the raw scale, \code{"change"} for
change from baseline, and \code{"difference"} for treatment difference
in terms of change from baseline. If \code{outcome} was \code{"change"},
then possible values include \code{"response"} for the response one the
change from baseline scale and \code{"difference"} for treatment difference.
\item \code{statistic}: type of summary statistic. \code{"lower"} and \code{"upper"}
are bounds of an equal-tailed quantile-based credible interval.
\item \code{group}: treatment group.
\item \code{time}: discrete time point.
\item \code{value}: numeric value of the estimate.
\item \code{mcse}: Monte Carlo standard error of the estimate.
The \code{statistic} column has the following possible values:
\item \code{mean}: posterior mean.
\item \code{median}: posterior median.
\item \code{sd}: posterior standard deviation of the mean.
\item \code{lower}: lower bound of an equal-tailed credible interval of the mean,
with credible level determined by the \code{level} argument.
\item \code{upper}: upper bound of an equal-tailed credible interval
with credible level determined by the \code{level} argument.
}
}
\description{
Summary statistics of the marginal posterior of an MMRM.
}
\examples{
if (identical(Sys.getenv("BRM_EXAMPLES", unset = ""), "true")) {
set.seed(0L)
data <- brm_data(
  data = brm_simulate()$data,
  outcome = "response",
  role = "response",
  group = "group",
  time = "time",
  patient = "patient"
)
formula <- brm_formula(
  data = data,
  effect_base = FALSE,
  interaction_base = FALSE
)
tmp <- utils::capture.output(
  suppressMessages(
    suppressWarnings(
      model <- brm_model(
        data = data,
        formula = formula,
        chains = 1,
        iter = 100,
        refresh = 0
      )
    )
  )
)
draws <- brm_marginal_draws(
  model = model,
  data = data,
  control = "group 1",
  baseline = "time 1"
)
suppressWarnings(brm_marginal_summaries(draws))
}
}
\seealso{
Other marginals: 
\code{\link{brm_marginal_data}()},
\code{\link{brm_marginal_draws_average}()},
\code{\link{brm_marginal_draws}()},
\code{\link{brm_marginal_probabilities}()}
}
\concept{marginals}
