% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brm_data.R
\name{brm_data}
\alias{brm_data}
\title{Create and preprocess an MMRM dataset.}
\usage{
brm_data(
  data,
  outcome = "CHG",
  role = "change",
  base = NULL,
  group = "TRT01P",
  time = "AVISIT",
  patient = "USUBJID",
  covariates = character(0)
)
}
\arguments{
\item{data}{Data frame or tibble with longitudinal data.}

\item{outcome}{Character of length 1, name of the outcome variable.}

\item{role}{Character of length 1. Either \code{"response"} if \code{outcome}
is the raw response variable (e.g. AVAL) or \code{"change"} if \code{outcome}
is change from baseline (e.g. CHG).}

\item{base}{Character of length 1, name of the baseline response variable.
Supply \code{NULL} to ignore or omit.}

\item{group}{Character of length 1, name of the treatment group variable.
Must point to a character vector in the data. Factors are converted
to characters.}

\item{time}{Character of length 1, name of the discrete time variable.
Must point to a character vector in the data. Factors are converted
to characters.}

\item{patient}{Character of length 1, name of the patient ID variable.}

\item{covariates}{Character vector of names of other covariates.}
}
\value{
A classed tibble with attributes which denote features of
the data such as the treatment group and discrete time variables.
}
\description{
Create a dataset to analyze with an MMRM.
}
\section{Preprocessing}{

The preprocessing steps in \code{brm_data()} are as follows:
\itemize{
\item Perform basic assertions to make sure the data and other arguments
are properly formatted.
\item Convert the group and time columns to character vectors.
\item Sanitize the levels of the group and time columns using
\code{make.names(unique = FALSE, allow_ = TRUE)} to ensure agreement
between the data and the output of \code{brms}.
\item For each implicitly missing outcome observation, add explicit row
with the outcome variable equal to \code{NA_real_}.
\item Arrange the rows of the data by group, then patient, then discrete time.
\item Select only the columns of the data relevant to an MMRM analysis.
}
}

\section{Separation string}{

Post-processing in \code{\link[=brm_marginal_draws]{brm_marginal_draws()}} names each of the
group-by-time marginal means with the delimiting character string
from \code{Sys.getenv("BRM_SEP", unset = "|")}. Neither the column names
nor element names of the group and time variables can contain
this string. To set a custom string yourself, use
\code{Sys.setenv(BRM_SEP = "YOUR_CUSTOM_STRING")}.
}

\examples{
set.seed(0)
data <- brm_simulate()$data
colnames(data) <- paste0("col_", colnames(data))
data
brm_data(
  data = data,
  outcome = "col_response",
  role = "response",
  group = "col_group",
  time = "col_time",
  patient = "col_patient"
)
}
\concept{data}
