% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Landscape_Methods.R
\name{simulateLandscape}
\alias{simulateLandscape}
\title{Simulate a new landscape}
\usage{
simulateLandscape(
  n = 500,
  prop = 0.4,
  range = 10,
  xmin = 0,
  xmax = 5000,
  ymin = 0,
  ymax = 5000,
  border_size = 200,
  prob = runif(1, 0.1, 0.9),
  mean_thickness = runif(1, 2, 20),
  v_thickness = 50
)
}
\arguments{
\item{n}{Numeric, numbers of fields}

\item{prop}{Numeric [0,1] toxic fields proportion}

\item{range}{aggregation parameter (range of the spatial exponential covariance of gaussian process) in meters.}

\item{xmin}{x-axis left coordinates}

\item{xmax}{x-axis right coordinates}

\item{ymin}{y-axis bottom coordinates}

\item{ymax}{y-axis top coordinates}

\item{border_size}{A numeric, bbox margin}

\item{prob}{Probability to inflate a filed margin}

\item{mean_thickness}{Margin width expectation}

\item{v_thickness}{Margin width variance}
}
\value{
A \link[sp]{SpatialPolygonsDataFrame} object with n fields, prop pourcentage of toxic fields.
}
\description{
Create an object of class \link[sp]{SpatialPolygonsDataFrame}. Simulate a landscape with neutral and source fields and receptors margins.
}
\details{
Execute both \link{simulateInitialPartition} and \link{simulateThickMargins} functions.
}
\examples{
\dontrun{
land <- simulateLandscape(n=100, prop=0.4, range=10,
xmin=0, xmax=1000, ymin=0, ymax=1000, border_size=100,
prob=runif(1,0.1,0.9), mean_thickness=runif(1,2,20),
v_thickness=50)
plot(land) }

}
\seealso{
\link{simulateInitialPartition} and \link{simulateThickMargins}
}
