% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_breathid_xml.R
\name{read_breathid_xml}
\alias{read_breathid_xml}
\title{Read new BreathID/Examens XML file}
\usage{
read_breathid_xml(filename = NULL, text = NULL)
}
\arguments{
\item{filename}{name of xml-file to be read}

\item{text}{alternatively, text can be given as string}
}
\value{
List of class \code{breathtest_data_list} of structures of 
class \code{\link{breathtest_data}}; an XML file can contain multiple data sets.
}
\description{
Reads 13c data from an XML BreathID file, and returns a structure 
of class \code{breathtest_data_list}, which is a list with elements of 
class \code{breathtest_data}.
}
\examples{
filename = btcore_file("NewBreathID_01.xml")
# Show first lines
cat(readLines(filename, n = 10), sep="\n")
bid = read_breathid_xml(filename)
# List with length 1
str(bid, 1)
filename = btcore_file("NewBreathID_multiple.xml")
bids = read_breathid_xml(filename)
str(bids, 1) # 3 elements - the others in the file have no data
# Create hook function to deselect first record
choose_record = function(records) {
  r  = rep(TRUE, length(records))
  r[1] = FALSE
  r
}
options(breathtestcore.choose_record = choose_record)
bids = read_breathid_xml(filename)
str(bids, 1) # 2 elements, first deselected


}
