% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{cor.diff.test}
\alias{cor.diff.test}
\title{Calculate the p-value for differences in correlation coefficients}
\usage{
cor.diff.test(r1, r2, n, alternative = c("two.sided", "less", "greater"))
}
\arguments{
\item{r1, r2}{Numeric (vector or matrix) of correlation coefficients for both
groups}

\item{n}{Integer vector; number of observations for both groups}

\item{alternative}{Character string, whether to do a two- or one-sided test.
Default: \code{'two.sided'}}
}
\value{
A list with elements \code{p} and \code{z}, the p-values
  and z-scores for the difference in correlations.
}
\description{
Given two sets of correlation coefficients and sample sizes, this function
calculates and returns the \emph{z-scores} and \emph{p-values} associated
with the difference between correlation coefficients. This function was
adapted from \url{https://stackoverflow.com/a/14519007/3357706}.
}
\examples{
\dontrun{
kNumSubjs <- summary(covars$Group)
corr.diffs <- cor.diff.test(corrs$R[, , 1], corrs$R[, , 2], kNumSubjs)
edge.diffs <- t(sapply(which(corr.diffs$p < .05), function(x)
                       mapply('[[',
                              dimnames(corr.diffs$p),
                              arrayInd(x, dim(corr.diffs$p)))
                              ))
}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
