% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_corr_mat.R
\name{plot_corr_mat}
\alias{plot_corr_mat}
\title{Plot a correlation matrix}
\usage{
plot_corr_mat(corrs, ordered = TRUE, type = c("comm", "comm.wt",
  "lobe", "network"), g = NULL, group = NULL)
}
\arguments{
\item{corrs}{The correlation matrix}

\item{ordered}{A logical indicating whether or not to order vertices
(default:TRUE)}

\item{type}{Character string, one of: 'comm', 'comm.wt', 'lobe', or 'network'}

\item{g}{An igraph graph object; not required if \emph{ordered} is FALSE}

\item{group}{A character vector of the group name (default: NULL)}
}
\value{
A ggplot object
}
\description{
This function will plot a correlation matrix in the form of a ``heatmap''.
You have the choice to plot the vertices in an order based on either
community or lobe membership, and they will be colored accordingly.
}
\examples{
\dontrun{
matplot1 <- plot_corr_mat(corrs[[1]]$r.thresh[, , N], g=g[[1]][[N]],
                          group=groups[1])
}
}
\seealso{
\code{\link[ggplot2]{geom_tile}}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
