% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORI.R
\name{infactor_or1}
\alias{infactor_or1}
\title{Inefficiency factor for ordinal quantile model
with more than 3 outcomes}
\usage{
infactor_or1(x, beta, delta, autocorrelationCutoff)
}
\arguments{
\item{x}{covariate matrix of dimension \eqn{(n x k)} including a column of ones with or without column names.}

\item{beta}{Gibbs draw of coefficients of dimension \eqn{(k x nsim)}.}

\item{delta}{Gibbs draw of cut-points.}

\item{autocorrelationCutoff}{cut-off to identify the number of lags.}
}
\value{
Returns a list with components
\itemize{
\item{\code{inefficiencyDelta}: }{vector with inefficiency factor for each \eqn{\delta}.}
\item{\code{inefficiencyBeta}: }{vector with inefficiency factor for each \eqn{\beta}.}
}
}
\description{
This function calculates the inefficiency factor from the MCMC draws
of \eqn{(\beta, \delta)} for ordinal quantile model with more than 3 outcomes. The
inefficiency factor is calculated using the batch-means method.
}
\details{
Calculates the inefficiency factor of \eqn{(\beta, \delta)} using the batch-means
method.
}
\examples{
set.seed(101)
data("data25j4")
x <- data25j4$x
y <- data25j4$y
k <- dim(x)[2]
J <- dim(as.array(unique(y)))[1]
D0 <- 0.25*diag(J - 2)
output <- quantreg_or1(y = y,x = x, B0 = 10*diag(k), D0 = D0,
mcmc = 40, p = 0.25, tune = 1, display = FALSE)
beta <- output$beta
delta <- output$delta
inefficiency <- infactor_or1(x, beta, delta, 0.5)

# Summary of Inefficiency Factor:

#             Inefficiency
# beta_0        1.1008
# beta_1        3.0024
# beta_2        2.8543
# delta_1       3.6507
# delta_2       3.1784

}
\references{
Greenberg, E. (2012). “Introduction to Bayesian Econometrics.” Cambridge University
Press, Cambridge. DOI: 10.1017/CBO9780511808920
}
\seealso{
pracma, \link[stats]{acf}
}
