% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORI.R
\name{logMargLikelihood_or1}
\alias{logMargLikelihood_or1}
\title{Marginal likelihood for ordinal quantile model
with more than 3 outcomes}
\usage{
logMargLikelihood_or1(y, x, b0, B0, d0, D0, postMeanbeta,
postMeandelta, beta, delta, tune, Dhat, p)
}
\arguments{
\item{y}{observed ordinal outcomes, column vector of dimension \eqn{(n x 1)}.}

\item{x}{covariate matrix of dimension \eqn{(n x k)} including a column of ones with or without column names.}

\item{b0}{prior mean for normal distribution to sample \eqn{\beta}.}

\item{B0}{prior variance for normal distribution to sample \eqn{\beta}}

\item{d0}{prior mean for normal distribution to sample \eqn{\delta}.}

\item{D0}{prior variance for normal distribution to sample \eqn{\delta}.}

\item{postMeanbeta}{a vector with mean of sampled \eqn{\beta} for each covariate.}

\item{postMeandelta}{a vector with mean of sampled \eqn{\delta} for each cut-point.}

\item{beta}{a storage matrix with all sampled values for \eqn{\beta}.}

\item{delta}{a storage matrix with all sampled values for \eqn{\delta}.}

\item{tune}{tuning parameter to adjust MH acceptance rate.}

\item{Dhat}{negative inverse Hessian from maximization of log-likelihood.}

\item{p}{quantile level or skewness parameter, p in (0,1).}
}
\value{
Returns a scalar for logarithm of marginal likelihood
}
\description{
This function computes the logarithm of marginal likelihood for ordinal
quantile model with more than 3 outcomes using MCMC output from the
complete and reduced runs.
}
\details{
This function computes the logarithm of marginal likelihood for ordinal quantile model with more than
3 outcomes using the MCMC outputs.
}
\examples{
set.seed(101)
data("data25j4")
x <- data25j4$x
y <- data25j4$y
k <- dim(x)[2]
J <- dim(as.array(unique(y)))[1]
D0 <- 0.25*diag(J - 2)
output <- quantreg_or1(y = y,x = x, B0 = 10*diag(k), D0 = D0,
mcmc = 50, p = 0.25, tune = 1, display = FALSE)
# output$logMargLikelihood
#   -551.42

}
\references{
Rahman, M. A. (2016). “Bayesian
Quantile Regression for Ordinal Models.”
Bayesian Analysis, 11(1): 1-24. DOI: 10.1214/15-BA939

Chib, S., and Greenberg, E. (1995). “Understanding the Metropolis-Hastings
Algorithm.” The American Statistician, 49(4): 327-335. DOI: 10.2307/2684568

Chib, S. (1995). “Marginal likelihood from the Gibbs output.” Journal of the American
Statistical Association, 90(432):1313–1321, 1995. DOI: 10.1080/01621459.1995.10476635

Chib, S., and Jeliazkov, I. (2001). “Marginal likelihood from the Metropolis-Hastings output.” Journal of the
American Statistical Association, 96(453):270–281, 2001. DOI: 10.1198/016214501750332848

Greenberg, E. (2012). “Introduction to Bayesian Econometrics.” Cambridge University
Press, Cambridge. DOI: 10.1017/CBO9780511808920
}
\seealso{
\link[NPflow]{mvnpdf}, \link[stats]{dnorm},
Gibbs sampling, Metropolis-Hastings algorithm
}
