% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ODRI.R
\name{qrnegloglikensum}
\alias{qrnegloglikensum}
\title{Negative log-likelihood for Ordinal Model with more than 3 outcomes}
\usage{
qrnegloglikensum(deltaIn, y, x, beta, p)
}
\arguments{
\item{deltaIn}{initialization of cut-points.}

\item{y}{observed ordinal outcomes, column vector of dimension \eqn{(n x 1)}.}

\item{x}{covariate matrix of dimension \eqn{(n x k)} including a column of ones.}

\item{beta}{column vector of coefficients of dimension \eqn{(k x 1)}.}

\item{p}{quantile level or skewness parameter, p in (0,1).}
}
\value{
Returns a list with components
\itemize{
\item{\code{nlogl}: }{a vector with likelihood values.}
\item{\code{negsumlogl}: }{a scalar with value of negative log-likelihood.}
}
}
\description{
Function for calculating negative log-likelihood for ordinal model with
more than 3 outcomes.
}
\details{
Computes the negative of the log-likelihood function for
ordinal quantile regression model with more than 3 outcomes.
}
\examples{
set.seed(101)
deltaIn <- c(-0.002570995, 1.044481071)
data("data25j4")
x <- data25j4$x
y <- data25j4$y
p <- 0.25
beta <- c(0.3990094, 0.8168991, 2.8034963)
output <- qrnegloglikensum(deltaIn, y, x, beta, p)

# nlogl
#   0.7424858
#   1.1649645
#   2.1344390
#   0.9881085
#   2.7677386
#   0.8229129
#   0.8854911
#   0.3534490
#   1.8582422
#   0.9508680 .. soon

# negsumlogl
#   716.9498

}
\references{
Rahman, M. A. (2016). “Bayesian
Quantile Regression for Ordinal Models.”
Bayesian Analysis, 11(1): 1-24.
}
\seealso{
likelihood maximization
}
