% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ODRI.R
\name{drawbetag3}
\alias{drawbetag3}
\title{Samples \eqn{\beta} for an Ordinal Model
with more than 3 outcomes}
\usage{
drawbetag3(z, x, w, tau2, theta, invB0, invB0b0)
}
\arguments{
\item{z}{Gibbs draw of latent response variable, a column vector.}

\item{x}{covariate matrix of dimension \eqn{(n x k)} including a column of ones.}

\item{w}{latent weights, row vector.}

\item{tau2}{2/(p(1-p)).}

\item{theta}{(1-2p)/(p(1-p)).}

\item{invB0}{inverse of prior covariance matrix of normal distribution.}

\item{invB0b0}{prior mean pre-multiplied by invB0.}
}
\value{
Returns a column vector of \eqn{\beta}
from a multivariate normal distribution.
}
\description{
This function samples \eqn{\beta} from its conditional
posterior distribution for an ordinal model with more than 3
outcomes.
}
\details{
Function samples a vector of \eqn{\beta} from a multivariate
normal distribution.
}
\examples{
set.seed(101)
data("data25j4")
x <- data25j4$x
p <- 0.25
n <- dim(x)[1]
k <- dim(x)[2]
w <- array( (abs(rnorm(n, mean = 2, sd = 1))), dim = c (n, 1))
theta <- 2.666667
tau2 <- 10.66667
z <- array( (rnorm(n, mean = 0, sd = 1)), dim = c(n, 1))
b0 <- array(0, dim = c(k, 1))
B0 <- diag(k)
invB0 <- matrix(c(
     1, 0, 0,
     0, 1, 0,
     0, 0, 1),
     nrow = 3, ncol = 3, byrow = TRUE)
invB0b0 <- invB0 \%*\% b0
ans <- drawbetag3(z, x, w, tau2, theta, invB0, invB0b0)

# ans
#   -1.2230077 0.9520024 0.7102855
}
\references{
Rahman, M. A. (2016). “Bayesian
Quantile Regression for Ordinal Models.”
Bayesian Analysis, 11(1): 1-24.

Becker, R. A., Chambers, J. M. and Wilks, A. R. (1988).
“The New S Language. Wadsworth & Brooks/Cole.”

Casella, G., George E. I. (1992). “Explaining the Gibbs Sampler."
The American Statistician, 46(3): 167-174.

Geman, S., and Geman, D. (1984). “Stochastic Relaxation,
Gibbs Distributions, and the Bayesian Restoration of Images."
IEEE Transactions an Pattern Analysis and Machine Intelligence,
6(6): 721-741.
}
\seealso{
Gibbs sampling, normal distribution,
\link[MASS]{ginv},  \link[MASS]{mvrnorm}
}
