% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{create_grps}
\alias{create_grps}
\title{Create Groups for Dplyr}
\usage{
create_grps(data, inc_date, add_groups, inc_wake)
}
\arguments{
\item{data}{Supplied data from function}

\item{inc_date}{TRUE/FALSE indicator from function argument for whether or not to
include the date in grouping}

\item{add_groups}{Character vector from function argument input corresponding
to which other variables other than "ID", "WAKE", and "VISIT" to include from
the supplied data's column names. If "DATE" is supplied in add_groups, and
inc_date = TRUE, the duplicate will be omitted.}

\item{inc_wake}{Optional argument corresponding to whether or not to include \code{WAKE}
in the grouping of the final output (if \code{WAKE} column is available). By default,
\code{inc_wake = TRUE} which will include the \code{WAKE} column in the groups by which
to calculate the respective metrics.}
}
\value{
A vector of string values corresponding to the column names that
will subset / group the data in dplyr functions
}
\description{
Used in the following functions:
\code{arv}, \code{bp_mag}, \code{bp_range}, \code{cv}, \code{sv}, \code{bp_center}, \code{bp_stats}
}
