% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_process.R
\name{process_data}
\alias{process_data}
\title{Data Pre-Processor}
\usage{
process_data(
  data,
  sbp = NULL,
  dbp = NULL,
  bp_datetime = NULL,
  id = NULL,
  wake = NULL,
  visit = NULL,
  hr = NULL,
  pp = NULL,
  map = NULL,
  rpp = NULL,
  DoW = NULL,
  ToD_int = NULL,
  sbp_stages_alt = NULL,
  dbp_stages_alt = NULL
)
}
\arguments{
\item{data}{User-supplied dataset containing blood pressure data. Must
contain data for Systolic blood pressure and Diastolic blood pressure at a
minimum.}

\item{sbp}{Required column name (character string) corresponding to Systolic Blood
Pressure (mmHg)}

\item{dbp}{Required column name (character string) corresponding to Diastolic Blood
Pressure (mmHg)}

\item{bp_datetime}{Optional column name (character string) corresponding to Date/Time,
but HIGHLY recommended to supply if available.}

\item{id}{Optional column name (character string) corresponding to subject ID. Typically
needed for data corresponding to more than one subject. For one-subject datasets, ID
will default to 1 (if ID column not found in dataset)}

\item{wake}{Optional column name (character string) corresponding to sleep status. A
WAKE value of 1 indicates that the subject is awake and 0 implies asleep.}

\item{visit}{Optional column name (character string) corresponding to Visit number}

\item{hr}{Optional column name (character string) corresponding to Heart Rate (bpm)}

\item{pp}{Optional column name (character string) corresponding to Pulse Pressure
(SBP - DBP). If not supplied, it will be calculated automatically.}

\item{map}{Optional column name (character string) corresponding to Mean Arterial
Pressure}

\item{rpp}{Optional column name (character string) corresponding to Rate Pulse
Pressure (SBP * HR). If not supplied, but HR column available, then
RPP will be calculated automatically.}

\item{DoW}{Optional column name (character string) corresponding to the Day of the Week.
If not supplied, but DATE or DATE_TIME columns available, then DoW will be created
automatically. DoW values must be abbreviated as such \code{c("Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat")}}

\item{ToD_int}{Optional vector that overrides the default interval for the Time-of-Day periods.
By default, the Morning, Afternoon, Evening, and Night periods are set at 6, 12, 18, 0 respectively,
where 0 corresponds to the 24th hour of the day (i.e. Midnight). By inputting a vector for the
\code{ToD_int} function argument, the default period can be re-arranged accordingly.
For example, ToD_int = c(5, 13, 18, 23) would correspond to a period for
Morning starting at 5:00 (until 13:00), Afternoon starting at 13:00 (until 18:00),
Evening starting at 18:00 (until 23:00), and Night starting at 23:00 (until 5:00)}

\item{sbp_stages_alt}{(Optional) Determines the lower and upper limits for each stage
of systolic blood pressure (\code{SBP}). If supplied, the input must be a vector
containing 7 integers that correspond to the limits of each stage. The default vector would be
given by \code{c(80, 100, 120, 130, 140, 180, 200)} where:
\itemize{

   \item Low - default: < 100 (specifically 80 - 100)
   \item Normal - default: 100 - 120
   \item Elevated - default: 120 - 130
   \item Stage 1 - default: 130 - 140
   \item Stage 2 - default: 140 - 180
   \item Crisis - default: > 180 (specifically 180 - 200)

}}

\item{dbp_stages_alt}{(Optional) Determines the lower and upper limits for each stage
of diastolic blood pressure (\code{DBP}). If supplied, the input must be a vector
containing 7 integers that correspond to the limits of each stage. The default vector would be
given by \code{c(25, 60, 80, 85, 90, 120, 140)} where:
\itemize{

   \item Low - default: < 60 (specifically 25 - 60)
   \item Normal - default: 60 - 80
   \item Elevated - default: 80 - 85
   \item Stage 1 - default: 85 - 90
   \item Stage 2 - default: 90 - 120
   \item Crisis - default: > 120 (specifically 120 - 140)

}}
}
\value{
A processed dataframe object that cooperates with every other
function within the bp package - all column names and formats comply.
}
\description{
A helper function to assist in pre-processing the user-supplied
input data for use with other functions.
Typically, this function will process the data and be stored as another
dataframe. This function ensures that the supplied data complies with every
function within the \code{bp} package. See Vignette for further details.
}
\examples{
# Load hypnos_data
data("hypnos_data")

# Process data for hypnos_data
hyp_proc <- process_data(hypnos_data, sbp = "SYST", dbp = "DIAST", bp_datetime = "date.time",
id = "id", wake = "wake", visit = "visit", hr = "hr", pp ="pp", map = "map", rpp = "rpp")

hyp_proc

# Load bp_jhs data
data("bp_jhs")

# Process data for bp_jhs
jhs_proc <- process_data(bp_jhs, sbp = "Sys.mmHg.", dbp = "Dias.mmHg.", bp_datetime = "DateTime",
hr = "Pulse.bpm.")

jhs_proc

}
