% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generalised.R
\name{generalised}
\alias{generalised}
\title{Generalised Bootstrap}
\usage{
generalised(ys, pks, B, distribution = c("uniform", "normal",
  "exponential", "lognormal"))
}
\arguments{
\item{ys}{values of the variable of interest for the original sample}

\item{pks}{inclusion probabilities for units in the sample}

\item{B}{integer scalar, number of bootstrap resamples to draw from the pseudo-population}

\item{distribution}{the distribution from which to generate the weights 
adjustments. One of \code{uniform}, \code{normal} or \code{lognormal}.}
}
\value{
a list of two elements, a vector of K average bootstrap totals and
a vector of K variance estimates.
}
\description{
Compute bootstrap estimates according to Generalised Bootstrap procedure by
Beaumont and Patak (2012)
}
\references{
Bertail, P., & Combris, P. (1997). Bootstrap généralisé d'un sondage. 
Annales d'Economie et de Statistique, 49-83.

Beaumont, J. F., & Patak, Z. (2012). On the generalized bootstrap for sample 
surveys with special attention to Poisson sampling. 
International Statistical Review, 80(1), 127-148.
}
\keyword{internal}
