% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internalFunctions.R
\name{ssNormPars}
\alias{ssNormPars}
\title{Compute the sum of squares between the theoretical and observed quantiles of a normal / Gaussian distribution.}
\usage{
ssNormPars(muSigPars, pLow, pUpp, alpha = 0.05)
}
\arguments{
\item{muSigPars}{The mean and standard deviation parameters of the theoretical normal distribution.}

\item{pLow}{The observed lower quantile .}

\item{pUpp}{The observed upper quantile.}

\item{alpha}{The confidence level; i.e. the desired coverage is 1-alpha. Defaults to 0.05.}
}
\value{
A single number, the sum of squares.
}
\description{
This is a helper function that compute the sum of squares between two theoretical and observed quantiles of a normal distribution (typically the lower and upper bounds of a confidence interval).
This function is for internal use to find the best-fit normal distribution for a given confidence interval.
}
\seealso{
\code{\link{identifyNormPars}}, \code{\link{optim}}, \code{\link{qnorm}}
}
