% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_functions.R
\name{basic_functions}
\alias{basic_functions}
\alias{sin_pi}
\alias{cos_pi}
\alias{log1p_boost}
\alias{expm1_boost}
\alias{cbrt}
\alias{sqrt1pm1}
\alias{powm1}
\alias{hypot}
\alias{rsqrt}
\title{Basic Mathematical Functions}
\usage{
sin_pi(x)

cos_pi(x)

log1p_boost(x)

expm1_boost(x)

cbrt(x)

sqrt1pm1(x)

powm1(x, y)

hypot(x, y)

rsqrt(x)
}
\arguments{
\item{x}{Input numeric value}

\item{y}{Second input numeric value (for power and hypotenuse functions)}
}
\value{
A single numeric value with the computed result of the function.
}
\description{
Functions to compute sine, cosine, logarithm, exponential, cube root, square root, power, hypotenuse, and inverse square root.
}
\examples{
# sin(pi * 0.5)
sin_pi(0.5)
# cos(pi * 0.5)
cos_pi(0.5)
# log(1 + 0.5)
log1p_boost(0.5)
# exp(0.5) - 1
expm1_boost(0.5)
cbrt(8)
# sqrt(1 + 0.5) - 1
sqrt1pm1(0.5)
# 2^3 - 1
powm1(2, 3)
hypot(3, 4)
rsqrt(4)
}
\seealso{
\href{https://www.boost.org/doc/libs/1_87_0/libs/math/doc/html/math_toolkit/powers.html}{Boost Documentation}) for more details on the mathematical background.
}
