% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/naivepop.R
\name{naivepop}
\alias{naivepop}
\title{Naive Overall Population Model Estimation}
\usage{
naivepop(resp, trt, data, resptype = c("survival", "binary"), status = NULL)
}
\arguments{
\item{resp}{(\code{string})\cr the response variable name.}

\item{trt}{(\code{string})\cr the treatment variable name. The treatment variable
must be a factor with 2 levels where the first level is the control and the
second one the treatment.}

\item{data}{(\verb{data frame})\cr the data frame with the variables.}

\item{resptype}{(\code{string})\cr the type of data used. Can be "survival"
or "binary".}

\item{status}{(\code{string})\cr only for "survival" \code{resptype},
the status variable name in survival data.}
}
\value{
List with \code{fit}, \code{model}, \code{resptype}, \code{data}.
}
\description{
Function to fit the naive overall population model to the data. This model is going to
estimate the subgroup treatment effects with the overall population
treatment effect.
}
\examples{
naivepop("tt_pfs", "arm", example_data, "survival", "ev_pfs")
}
