% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BMSC-pairwise.R
\name{pairwise.BMSC}
\alias{pairwise.BMSC}
\title{Pairwise contrasts}
\usage{
pairwise.BMSC(mdl, contrast, covariate = NULL, who = "delta")
}
\arguments{
\item{mdl}{An object of class \code{BMSC}.}

\item{contrast}{Character value giving the name of the coefficient whose levels need to be compared.}

\item{covariate}{at the moment is silent}

\item{who}{parameter to choose the estimates to contrast
\describe{
        \item{control}{only the controls}
        \item{singlecase}{only the single case \eqn{(\beta + \delta)}}
        \item{delta}{only the difference between the single case and controls}
}}
}
\value{
a \code{pairwise.BMSC} object
}
\description{
Calculate pairwise comparisons between marginal posterior distributions divided by group levels
}
\examples{
 \donttest{

 data(BSE)

# Normal regression of data coming from a body representation paradigm
# with a control sample of 12 participants and one single case with
# unilateral brachial plexus lesion
mdl <- BMSC(formula = RT ~ Body.District * Congruency * Side +
            (Body.District + Congruency + Side | ID),
            data_ctrl = data.ctrl,
            data_sc = data.pt,
            cores = 4)

 # generate a summary of the results
 summary(mdl)

 # posterior predictive p-value checking
 pp_check(mdl, limited = FALSE)

 # plot of the results
 plot(mdl)

 # compute pairwise contrasts
 pairwise(mdl , contrast = "Body.District1:Side1")
}

}
