% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blr-model-fit-stats.R
\name{blr_rsq_cox_snell}
\alias{blr_rsq_cox_snell}
\title{Cox Snell R2}
\usage{
blr_rsq_cox_snell(model)
}
\arguments{
\item{model}{An object of class \code{glm}.}
}
\value{
Cox Snell pseudo r-squared.
}
\description{
Cox Snell pseudo r-squared.
}
\examples{
model <- glm(honcomp ~ female + read + science, data = hsb2,
            family = binomial(link = 'logit'))

blr_rsq_cox_snell(model)

}
\references{
Cox, D. R., & Snell, E. J. (1989). The analysis of binary data (2nd ed.).  London: Chapman and Hall. 

Maddala, G. S. (1983). Limited dependent and qualitative variables in economics. New York: Cambridge Press.
}
\seealso{
Other model fit statistics: \code{\link{blr_model_fit_stats}},
  \code{\link{blr_multi_model_fit_stats}},
  \code{\link{blr_pairs}}, \code{\link{blr_rsq_adj_count}},
  \code{\link{blr_rsq_effron}},
  \code{\link{blr_rsq_mcfadden_adj}},
  \code{\link{blr_rsq_mckelvey_zavoina}},
  \code{\link{blr_rsq_nagelkerke}},
  \code{\link{blr_test_lr}}
}
