% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blr-residual-diagnostics.R
\name{blr_plot_diag_influence}
\alias{blr_plot_diag_influence}
\title{Influence diagnostics plot}
\usage{
blr_plot_diag_influence(model)
}
\arguments{
\item{model}{An object of class \code{glm}.}
}
\value{
A panel of influence diagnostic plots.
}
\description{
Reisudal diagnostic plots for detecting influential observations.
}
\examples{
model <- glm(honcomp ~ female + read + science, data = hsb2,
family = binomial(link = 'logit'))

blr_plot_diag_influence(model)

}
\references{
Pregibon, D. (1981), “Logistic Regression Diagnostics,” Annals of Statistics, 9, 705–724. 

Fox, John (1991), Regression Diagnostics. Newbury Park, CA: Sage Publications.

Cook, R. D. and Weisberg, S. (1982), Residuals and Influence in Regression, New York: Chapman & Hall.
}
\seealso{
Other diagnostic plots: \code{\link{blr_plot_diag_fit}},
  \code{\link{blr_plot_diag_leverage}}
}
