% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upper_bounds.r
\name{upper_bounds}
\alias{upper_bounds}
\title{Efficiency bounds}
\usage{
upper_bounds(n, v, b)
}
\arguments{
\item{n}{the total number of plots in the design.}

\item{v}{the total number of treatments in the design.}

\item{b}{the total number of blocks in the design.}
}
\description{
Finds upper A-efficiency bounds for regular block designs.
}
\details{
Upper bounds for the A-efficiency factors of regular block designs 
(see Chapter 2.8 of John and Williams 1995). Non-trivial A-efficiency upper bounds
are calculated for regular block designs with equal block sizes 
and equal replication. All other designs return NA.
}
\examples{

# 50 plots, 10 treatments and 10 blocks for a design with 5 replicates and blocks of size 5 
upper_bounds(n=50,v=10,b=10)

}
\references{
John, J. A. and Williams, E. R. (1995). Cyclic and Computer Generated Designs. Chapman and Hall, London.
}
