% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulate_Data.R
\name{corr_matrix}
\alias{corr_matrix}
\title{corr_matrix}
\usage{
corr_matrix(diagonal, ksi)
}
\arguments{
\item{diagonal}{a numerical vector corresponding to the diagonal.}

\item{ksi}{a numerical value, related to the correlation.}
}
\value{
a symmetric matrix.
}
\description{
Compute an autocorrelation matrix.
}
\examples{
### Test 1 : weak autocorrelation
ksi     <- 1
diagVar <- abs(rnorm(100,50,5))
Sigma   <- corr_matrix(diagVar,ksi^2)
persp(Sigma)
### Test 2 : strong autocorrelation
ksi     <- 0.2
diagVar <- abs(rnorm(100,50,5))
Sigma   <- corr_matrix(diagVar,ksi^2)
persp(Sigma)
}
