% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_email.R
\name{suppress_scheduled_email}
\alias{suppress_scheduled_email}
\title{Suppress any scheduled emailing in RStudio Connect}
\usage{
suppress_scheduled_email(suppress = TRUE)
}
\arguments{
\item{suppress}{A logical value for whether email suppression should occur
after publication. By default, this is \code{TRUE}.}
}
\description{
This function is useful for suppressing the scheduled emailing of a published
R Markdown document. It can be invoked anywhere in the R Markdown document
and is useful in a conditional statement, where the result of the condition
determines whether or not email suppression should occur.
}
\details{
Since this function needs to be invoked within an R Markdown document, the
chunk option \code{echo=FALSE} is useful here (so that viewers of the rendered
document don't have to unnecessarily read code related to email suppression).
While the output is invisible, any errors related to the use of this function
will be visible to the author.
}
