% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_image.R
\name{add_image}
\alias{add_image}
\title{Helper function for adding an image}
\usage{
add_image(file)
}
\arguments{
\item{file}{a path to an image file.}
}
\value{
a character object with an HTML
fragment that can be placed inside the
message body wherever the image should
appear.
}
\description{
Add an image inside the
body of the email with this helper
function.
}
\examples{
# Create an HTML fragment that
# contains an image
img_file_path <-
  system.file(
    "graphics",
    "melon_cat.png",
    package = "blastula")

img_file_html <-
  add_image(
    file = img_file_path)

# Include the image in the email
# message body by simply referencing
# the `img_file_html` object
email <-
  compose_email(
    body = "
    Hello!

    Take a look at this image:

    {img_file_html}

    Funny, right?
    ")
}
