% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cubicbs.R
\name{cubicbs}
\alias{cubicbs}
\title{Construct a cubic B-spline basis.}
\usage{
cubicbs(x, lower, upper, K)
}
\arguments{
\item{x}{A numeric vector containing the values on which to evaluate the
B-spline basis.}

\item{lower, upper}{The lower and upper bounds of the B-spline basis domain.
Must be finite with \code{lower < upper}.}

\item{K}{A positive integer specifying the number of B-spline functions in
the basis.}
}
\value{
An object of class \code{cubicbs} for which
\code{print} and \code{plot} methods are available. The \code{cubicbs}
class consists of a list with the following components:

\item{x}{A numeric vector on which the basis is evaluated.}

\item{lower, upper \verb{ }}{The lower and upper bounds of the basis domain.}

\item{K}{The number of cubic B-spline functions in the basis.}

\item{knots}{The knot sequence to build the basis.}

\item{nknots}{Total number of knots.}

\item{dimbasis}{The dimension of the B-spline basis matrix.}

\item{Bmatrix}{The B-spline basis matrix.}

The \code{print} method summarizes the B-spline basis and the \code{plot}
method gives a graphical representation of the basis
with dashed vertical lines indicating knot placement and blue ticks the
coordinates of \code{x}.
}
\description{
Computation of a cubic B-spline basis matrix.
}
\examples{
lb <- 0  # Lower bound
ub <- 1  # Upper bound
xdom <- runif(100, lb, ub) # Draw uniform values between lb and ub
Bsmat <- cubicbs(xdom, lb, ub, 25) # 100 x 25 B-spline matrix
Bsmat
plot(Bsmat) # Plot the basis
}
\references{
Eilers, P.H.C. and Marx, B.D. (1996). Flexible smoothing with
B-splines and penalties. \emph{Statistical Science}, \strong{11}(2): 89-121.
}
\author{
Gressani Oswaldo \email{oswaldo_gressani@hotmail.fr}.

The core algorithm of the \code{cubicbs} function owes much to a code written
by Phlilippe Lambert.
}
