% Generated by roxygen2 (4.0.2): do not edit by hand
\name{bizdays}
\alias{bizdays}
\title{Computes business days between two dates.}
\usage{
bizdays(from, to, cal = bizdays.options$get("default.calendar"))
}
\arguments{
\item{from}{the initial dates}

\item{to}{the final dates}

\item{cal}{an instance of \code{Calendar}}
}
\value{
\code{integer} objects representing the amount of business days.
}
\description{
Returns the amount of business days between 2 dates taking into account the
provided \code{Calendar} (or \code{bizdays.options$get("default.calendar")}).
}
\section{Date types accepted}{


The arguments \code{from} and \code{to} accept \code{Date} objects and any
object that returns a valid \code{Date} object when passed through
\code{as.Date}, which include all \code{POSIX*} classes and \code{character}
objects with ISO formatted dates.
}

\section{Recycle rule}{


These arguments handle the recycle rule so vectors of dates can be provided
and once those vectors differs in length the recycle rule is applied.
}

\section{Date adjustment}{


\code{from} and \code{to} are adjusted when nonworking dates are
provided. Since \code{bizdays} function returns the amount of business days
between 2 dates, it must start and end in business days.
The default behavior, that is defined in \code{Calendar}'s instantiation with
\code{adjust.from} and \code{adjust.to}, reproduces the Excel's NETWORKDAYS.
A common and useful setting is \code{adjust.to=adjust.next} which moves
expiring maturities to the next business day, once it is not.
}
\examples{
data(holidaysANBIMA)
cal <- Calendar(holidaysANBIMA, weekdays=c("saturday", "sunday"))

bizdays("2013-01-02", "2013-01-31", cal)

# Once you have a default calendar set, cal does not need to be provided
bizdays.options$set(default.calendar=cal)
bizdays("2013-01-02", "2013-01-31")

dates <- bizseq("2013-01-01", "2013-01-10")
bizdays(dates, "2014-01-31")
}
\seealso{
\code{\link{bizyears}} for business days values in years.
}

