% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error.R
\name{compute_bisg_err}
\alias{compute_bisg_err}
\title{Calculate error on the BISG output, given input probability distributions.}
\usage{
compute_bisg_err(p_g_r, p_r_s, p_g_r_err, p_r_s_err)
}
\arguments{
\item{p_g_r}{A tibble denoting the probability of a geography, given race.
Each row in the tibble denotes a voter.}

\item{p_r_s}{A tibble denoting the probability of a racial group, given a
surname. Each row in the tibble denotes a voter.}

\item{p_g_r_err}{A tibble denoting the error on the probability of a
geography, conditioned on racial group. Same size as p_g_r.}

\item{p_r_s_err}{A tibble denoting the error on the probability of racial
group, conditioned on race. Same size as p_r_s.}
}
\value{
The error on the posterior probability.
}
\description{
This function calculates the error on the posterior probability given the
two distributions - probability of geography conditioned on race, and
probability of race conditioned on surname - that are used to perform BISG.
}
