% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniformE_selection.R
\name{uniformE_selection}
\alias{uniformE_selection}
\title{Selection of survey sites maximizing uniformity in environmental space}
\usage{
uniformE_selection(master, variable_1 = NULL, variable_2 = NULL,
                   selection_from = "all_points", expected_points,
                   guess_distances = TRUE, initial_distance = NULL,
                   increase = NULL, max_n_samplings = 1,
                   replicates = 10, use_preselected_sites = TRUE,
                   median_distance_filter = NULL, set_seed = 1,
                   verbose = TRUE, force = FALSE)
}
\arguments{
\item{master}{master_matrix object derived from function
\code{\link{prepare_master_matrix}} or master_selection object derived
from functions \code{\link{random_selection}},
\code{\link{uniformG_selection}}, or \code{\link{EG_selection}}.}

\item{variable_1}{(character or numeric) name or position of the first
variable (x-axis). If the function \code{\link{make_blocks}} was used in a
previous step, the default, NULL, will use the same two variables, otherwise
this argument must be defined.}

\item{variable_2}{(character or numeric) name or position of the second
variable (y-axis). If the function \code{\link{make_blocks}} was used in a
previous step, the default, NULL, will use the same two variables, otherwise
this argument must be defined.}

\item{selection_from}{(character) set of points to perform the selection
from. Two options are available, "all_points" or "block_centroids". The
first option picks the points from all points in the environmental cloud,
and the second one selects points only from centroids of environmental
blocks. See \code{\link{make_blocks}}. Default = "all_points".}

\item{expected_points}{(numeric) number of survey points (sites) to be
selected.}

\item{guess_distances}{(logical) whether or not to use internal algorithm
to automatically select \code{initial_distance} and \code{increase}. Default
= TRUE. If FALSE, \code{initial_distance} and \code{increase} must be
defined.}

\item{initial_distance}{(numeric) Euclidean distance to be used for a first
process of thinning and detection of remaining points. Default = NULL.}

\item{increase}{(numeric) initial value to be added to or subtracted from
\code{initial_distance} until reaching the number of \code{expected_points}.
Default = NULL.}

\item{max_n_samplings}{(numeric) maximum number of samples to be chosen
after performing all thinning \code{replicates}. Default = 1.}

\item{replicates}{(numeric) number of thinning replicates. Default = 10.}

\item{use_preselected_sites}{(logical) whether to use sites that have been
defined as part of the selected sites previous any selection. Object in
\code{master} must contain the site(s) preselected in and element of name
"preselected_sites" for this argument to be effective. Default = TRUE.
See details for more information on the approach used.}

\item{median_distance_filter}{(character) optional argument to define a
median distance-based filter based on which sets of sampling sites will be
selected. The default, NULL, does not apply such a filter. Options are:
"max" and "min".}

\item{set_seed}{(numeric) integer value to specify a initial seed.
Default = 1.}

\item{verbose}{(logical) whether or not to print messages about the process.
Default = TRUE.}

\item{force}{(logical) whether to replace existing set of sites selected
with this method in \code{master}.}
}
\value{
A \code{\link{master_selection}} object (S3) with an element called
selected_sites_E containing one or more sets of selected sites.
}
\description{
Selection of sites to be sampled in a survey, with the goal of
maximizing uniformity of points in environmental space.
}
\details{
Survey sites are selected in ways in which points will be uniformly
dispersed in environmental space, helping to select sites that present
different environmental conditions across the area of interest. This type of
selection is very useful to include, in the selected sites, distinct
environmental combinations existent in the area of interest. However, as the
distribution of climatic or other environmental combinations is not uniform
in geography, the sites selected with this function could appear clustered
when looked in a map.

Exploring the geographic and environmental spaces of the region of interest
would be a crucial first step before selecting survey sites. Such
explorations can be done using the function \code{\link{explore_data_EG}}.

If \code{use_preselected_sites} = TRUE and such sites are included as an
element in the object in \code{master}, the approach for selecting uniform
sites in environmental space is different than what was described above.
User-preselected sites will always be part of the sites selected. Other
points are selected based on an algorithm that searches for sites that are
uniformly distributed in environmental space but at a distance from
preselected sites that helps in maintaining uniformity. Note that
preselected sites will not be processed; therefore, uniformity of such points
cannot be warrantied. As multiple sets could result from selection, the
argument of the function \code{median_distance_filter} could be used to
select the set of sites with the maximum ("max") or minimum ("min") median
distance among selected sites. Option "max" will increase the geographic
distance among sampling sites, which could be desirable if the goal is to
cover the region of interest more broadly. The other option, "min", could be
used in cases when the goal is to reduce resources and time needed to sample
such sites.
}
\examples{
# Data
data("m_matrix", package = "biosurvey")

# Making blocks for analysis
m_blocks <- make_blocks(m_matrix, variable_1 = "PC1",
                        variable_2 = "PC2", n_cols = 10, n_rows = 10,
                        block_type = "equal_area")

# Checking column names
colnames(m_blocks$data_matrix)

# Selecting sites uniformly in E space
# because the make_blocks function was used, the same two variables will be
# used by default.
selectionE <- uniformE_selection(m_blocks, selection_from = "block_centroids",
                                 expected_points = 15, max_n_samplings = 1,
                                 replicates = 5, set_seed = 1)
}
\seealso{
\code{\link{uniformG_selection}}, \code{\link{random_selection}},
\code{\link{EG_selection}}, \code{\link{make_blocks}},
\code{\link{plot_sites_EG}}
}
