% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.ensembl.info.R
\name{get.ensembl.info}
\alias{get.ensembl.info}
\title{Helper function to retrieve species information from the ENSEMBL API}
\usage{
get.ensembl.info(update = FALSE, division)
}
\arguments{
\item{update}{logical, default FALSE. If TRUE, force re-download of info.}

\item{division}{the ENSEMBL database (division) for which information shall
be retrieved (available options can be obtained with \code{\link{ensembl_divisions}}).}
}
\description{
This function interfaces with the ENSEMBL API
(https://rest.ensembl.org/info/species?content-type=application/json)
and internally stores the output to use this information for subsequent
retrieval function calls.
}
\examples{
\dontrun{
# Look at available ENSEMBL division options
ensembl_divisions()
# Retrieve available information for EnsemblVertebrates
example <- get.ensembl.info(division = "EnsemblVertebrates")
example
# Update information file stored in the tempdir() folder.
example_update <- get.ensembl.info(division = "EnsemblVertebrates", update = TRUE)
example_update
}
}
\seealso{
\code{\link{ensembl_divisions}}, \code{\link{getKingdomAssemblySummary}}, \code{\link{getENSEMBLInfo}}
}
\author{
Hajk-Georg Drost
}
