% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{preprocess}
\alias{preprocess}
\title{Get central moments of objects in a single-channel image stack}
\usage{
preprocess(file, threshold = 0.95, threshW = 5, threshH = 5,
  brushsize = 3, quantile = TRUE)
}
\arguments{
\item{file}{the path of the image stack}

\item{threshold}{the quantile of intensities used for thresholding if quantile=TRUE 
or the intensity value if quantile=FALSE, defaults to the 80\% quantile}

\item{threshW}{width of the moving rectangular window for threshold, defaults to 5.}

\item{threshH}{height of the moving rectangular window for threshold, defaults to 5.}

\item{brushsize}{the brushsize for makeBrush for opening, defaults to 3}

\item{quantile}{defaults to TRUE}
}
\value{
a list with the original stack, the labeled stack, and the matrix of central moments of the found objects
}
\description{
Uses the methodology used for segmentation in the EBImage vignette 
 (threshhold->opening->fillHull) from all 3 spatial directions and 
 overlays these results to get a binary image which is then segmented 
 with bwlabel3d. Central moments are extracted with cmoments3d
}

