% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/criterions.R
\name{calc_criterion}
\alias{calc_criterion}
\title{Calculate value of criterion}
\usage{
calc_criterion(target, features, criterion_function)
}
\arguments{
\item{target}{\code{integer} vector with target information (e.g. class labels).}

\item{features}{\code{integer} matrix of features with number of rows equal 
to the length of the target vector.}

\item{criterion_function}{a function calculating criterion. For a full list, see 
\code{\link{test_features}}.}
}
\value{
a \code{integer} vector of length equal to the number of features 
containing computed information gain values.
}
\description{
Computes a chosen statistical criterion for each feature versus target vector.
}
\details{
The permutation test implemented in \code{biogram} uses several criterions to filter 
important features. Each can be used by \code{\link{test_features}} by specifying the 
\code{criterion} parameter.
}
\note{
Both \code{target} and \code{features} must be binary, i.e. contain only 0 
and 1 values.
}
\examples{
tar <- sample(0L:1, 100, replace = TRUE)
feats <- matrix(sample(0L:1, 400, replace = TRUE), ncol = 4)

# Information Gain
calc_criterion(tar, feats, calc_ig)

# hi-squared-based measure
calc_criterion(tar, feats, calc_cs)

# Kullback-Leibler divergence
calc_criterion(tar, feats, calc_kl)
}
\seealso{
\code{\link{test_features}}.
}

