% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics.R, R/gbLocation-class.R,
%   R/gbFeature-class.R, R/gbFeatureTable-class.R, R/gbRecord-class.R,
%   R/gbRecordList-class.R
\docType{methods}
\name{span}
\alias{span}
\alias{joint_range}
\alias{span,gbLocation-method}
\alias{joint_range,gbLocation-method}
\alias{span,gbFeature-method}
\alias{joint_range,gbFeature-method}
\alias{span,gbFeatureTable-method}
\alias{joint_range,gbFeatureTable-method}
\alias{span,gbRecord-method}
\alias{span,gbRecordList-method}
\title{Get the span of genomic features.}
\usage{
span(x, ...)

joint_range(x)

\S4method{span}{gbLocation}(x, join = FALSE)

\S4method{joint_range}{gbLocation}(x)

\S4method{span}{gbFeature}(x, join = FALSE)

\S4method{joint_range}{gbFeature}(x)

\S4method{span}{gbFeatureTable}(x, join = FALSE)

\S4method{joint_range}{gbFeatureTable}(x)

\S4method{span}{gbRecord}(x, join = FALSE)

\S4method{span}{gbRecordList}(x, join = FALSE)
}
\arguments{
\item{x}{A \code{\linkS4class{gbFeature}}, \code{\linkS4class{gbFeatureTable}},
\code{\linkS4class{gbRecord}}, or \code{\linkS4class{gbRecordList}} object.}

\item{...}{Further arguments passed to methods.}

\item{join}{Join compound genomic locations into a single range.}
}
\value{
An integer vector or a list of integer vectors.
}
\description{
Get the span of genomic features.
}
\examples{
load(system.file("extdata", "marine_metagenome.rda", package = "biofiles"))
span(x)
}
\seealso{
\code{\link{start}}, \code{\link{end}}, \code{\link{strand}}, \code{\link{ranges}}
}
