% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics.R, R/gbFeature-class.R,
%   R/gbFeatureTable-class.R, R/gbRecord-class.R
\docType{methods}
\name{qualifList}
\alias{qualifList}
\alias{qualifList,gbFeature-method}
\alias{qualifList,gbFeatureTable-method}
\alias{qualifList,gbRecord-method}
\title{List the names of Genbank qualifiers.}
\usage{
qualifList(x, ...)

\S4method{qualifList}{gbFeature}(x)

\S4method{qualifList}{gbFeatureTable}(x)

\S4method{qualifList}{gbRecord}(x)
}
\arguments{
\item{x}{A \code{\linkS4class{gbFeature}}, \code{\linkS4class{gbFeatureTable}},
\code{\linkS4class{gbRecord}}, or \code{\linkS4class{gbRecord}} object.}

\item{...}{Additional arguments to be passed to or from methods.}
}
\value{
A character vector (or list of character vectors) of 
   qualifier names.
}
\description{
List the names of Genbank qualifiers.
}
\examples{
load(system.file("extdata", "marine_metagenome.rda", package = "biofiles"))
qualifList(x["source"])
}
\seealso{
\code{\link{uniqueQualifs}}, \code{\link{hasQualif}}
}
