% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compose-extension.R
\name{compose_extension_v1.4.2}
\alias{compose_extension_v1.4.2}
\alias{compose_extension}
\title{Compose BioCompute Object - Extension Domain (v1.4.2)}
\usage{
compose_extension_v1.4.2(fhir = NULL, scm = NULL)

compose_extension(fhir = NULL, scm = NULL)
}
\arguments{
\item{fhir}{FHIR extension domain composed by \code{\link{compose_fhir}}.}

\item{scm}{SCM extension domain composed by \code{\link{compose_scm}}.}
}
\value{
A list of class \code{bco.domain}
}
\description{
Compose BioCompute Object - Extension Domain (v1.4.2)
}
\examples{
fhir_endpoint <- "https://fhirtest.uhn.ca/baseDstu3"
fhir_version <- "3"
fhir_resources <- data.frame(
  "id" = c("21376", "6288583", "25544", "92440", "4588936"),
  "resource" = c(
    "Sequence", "DiagnosticReport", "ProcedureRequest",
    "Observation", "FamilyMemberHistory"
  ),
  stringsAsFactors = FALSE
)

fhir <- compose_fhir(fhir_endpoint, fhir_version, fhir_resources)

scm_repository <- "https://github.com/example/repo"
scm_type <- "git"
scm_commit <- "c9ffea0b60fa3bcf8e138af7c99ca141a6b8fb21"
scm_path <- "workflow/hive-viral-mutation-detection.cwl"
scm_preview <- "https://github.com/example/repo/blob/master/mutation-detection.cwl"

scm <- compose_scm(scm_repository, scm_type, scm_commit, scm_path, scm_preview)

compose_extension(fhir, scm) \%>\% convert_json()
}
