% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_ith_raster.R
\name{ithRaster}
\alias{ithRaster}
\title{Function to calculate Thornthwaite’s index (raster format)}
\usage{
ithRaster(bh)
}
\arguments{
\item{bh}{Water balance in SpatRaster format from watbalRaster() function.}
}
\value{
Numeric, describing the humid characteristics of the climate. 1: 'HyperArid', 2: 'Arid', 3: 'Semiarid', 4: 'Dry humid', 5: 'Moist humid', 6 'Low humid', 7: 'Moderate humid', 8: 'Highly humid', 9: 'Very humid', 10: 'Perhumid'.
}
\description{
This function calculates Thornthwaite’s index to refine the bioclimatic classification.
}
\examples{
\donttest{
wb <- terra::rast(wbRast)
itr <- ithRaster(wb)
}
}
