% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_vpts.R
\name{filter_vpts}
\alias{filter_vpts}
\title{Filter a time series of vertical profiles ('vpts').}
\usage{
filter_vpts(x, min, max, nearest, night, elev = -0.268, offset = 0)
}
\arguments{
\item{x}{A \code{vpts} object.}

\item{min}{POSIXct date or character. Minimum datetime to be included.}

\item{max}{POSIXct date or character. Datetime up to this maximum included.}

\item{nearest}{POSIXct date or character. If specified, \code{min} and \code{max} are
ignored and the profile (\code{vp}) nearest to the specified datetime is
returned that matches the day/night selection criteria.}

\item{night}{When \code{TRUE} selects only nighttime profiles, when \code{FALSE}
selects only daytime profiles, as classified by \code{\link[=check_night]{check_night()}}.}

\item{elev}{Numeric (vector). Sun elevation in degrees defining nighttime.
May also be a numeric vector of length two, with first element giving
sunset elevation, and second element sunrise elevation.}

\item{offset}{Numeric (vector). Time duration in seconds by which to shift
the start and end of nighttime. May also be a numeric vector of length two,
with first element added to moment of sunset and second element added to
moment of sunrise. See \code{\link[=check_night]{check_night()}} for details.}
}
\value{
A \code{vpts} object, or a \code{vp} object when \code{nearest} is specified.
}
\description{
Filter a time series of vertical profiles ('vpts') by a start and end time,
for night or day time, or extract profile nearest to provided timestamp.
Use argument night = TRUE to select only time stamps between sunset and sunrise,
or night = FALSE to select daytime (sunrise to sunset). Selection for night and day uses
\code{\link[=check_night]{check_night()}}.
}
\details{
Returns profiles for which min <= timestamp profile < max. Selection for night and day
occurs by \link{check_night}.
}
\examples{
# Select profiles later than 02 Sep 2016

# Select the profile nearest to 2016-09-01 03:00 UTC
filter_vpts(example_vpts, nearest = "2016-09-01 03:00")

# Select profiles between than 01:00 and 03:00 UTC on 02 Sep 2016
filter_vpts(example_vpts, min = "2016-09-02 01:00", max = "2016-09-02 03:00")

# Select daytime profiles (i.e. profiles between sunrise and sunset)
filter_vpts(example_vpts, night = FALSE)

# Select nighttime profiles, with nights starting and ending at
# civil twilight (when the sun is 6 degrees below the horizon)
filter_vpts(example_vpts, night = TRUE, elev = -6)

# Select nighttime profiles from 3h after sunset to 2h before sunrise
filter_vpts(example_vpts, night = TRUE, offset = c(3, -2)*3600)

}
\seealso{
\itemize{
\item \code{\link[=summary.vpts]{summary.vpts()}}
\item \code{\link[=check_night]{check_night()}}
}
}
