test_that("map() returns error on incorrect parameters", {
  skip_if_offline()
  ppi <- project_as_ppi(example_scan)
  basemap <-  rosm::osm.types()[1]
  # return error when input object is not of class ppi
  expect_error(
    map("a"),
    regexp = 'no applicable method for \'map\' applied to an object of class "character"',
    fixed = TRUE
  )
  # return error when quantity is passed as an argument
  expect_error(
    map(ppi, quantity = 4),
    regexp = "unknown function argument 'quantity`. Did you mean `param`?",
    fixed = TRUE
  )
  # return error when param isn't a character string
  expect_error(
    map(ppi, param = 4),
    regexp = "'param' should be a character string with a valid scan parameter name.",
    fixed = TRUE
  )
  # return error on unexisting parameter
  expect_error(
    map(ppi, param = "not_a_parameter"),
    regexp = "no scan parameter 'not_a_parameter' in this ppi",
    fixed = TRUE
  )
  # return error on non projected ppi
  ppi_no_crs <- ppi
  raster::crs(ppi_no_crs$data) <- NA
  expect_error(
    map(ppi_no_crs),
    regexp = "Not a projected ppi, map() expects a ppi generated by project_as_ppi() with argument project=TRUE",
    fixed = TRUE
  )
  # return error when palette isn't a character vector
  expect_error(
    map(ppi, map = basemap, palette = 123),
    regexp = "palette should be a character vector with hex color values",
    fixed = TRUE
  )

})
