% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.scan.R
\name{plot.scan}
\alias{plot.scan}
\title{Plot a scan (\code{scan}) in polar coordinates}
\usage{
\method{plot}{scan}(
  x,
  param,
  xlim = c(0, 1e+05),
  ylim = c(0, 360),
  zlim = c(-20, 20),
  na.value = "transparent",
  ...
)
}
\arguments{
\item{x}{An object of class \code{scan}.}

\item{param}{The scan parameter to plot, see details below.}

\item{xlim}{Range of x (range, distance from radar) values to plot.}

\item{ylim}{Range of y (azimuth) values to plot.}

\item{zlim}{The range of parameter values to plot.}

\item{na.value}{\link[ggplot2]{ggplot} argument setting the plot color of NA values}

\item{...}{Arguments passed to low level \link[ggplot2]{ggplot} function.}
}
\description{
Plots a scan in polar coordinates. For plots in Cartesian coordinates,
see \code{project_to_ppi}
}
\details{
Available scan parameters for plotting can by printed to screen
by \code{summary(x)}. Commonly available parameters are:
\describe{
\item{"\code{DBZH}", "\code{DBZ}"}{(Logged) reflectivity factor (dBZ)}
\item{"\code{TH}", "\code{T}"}{(Logged) uncorrected reflectivity factor (dBZ)}
\item{"\code{VRADH}", "\code{VRAD}"}{Radial velocity (m/s). Radial
velocities towards the radar are negative, while radial velocities away
from the radar are positive}
\item{"\code{RHOHV}"}{Correlation coefficient (unitless). Correlation
between vertically polarized and horizontally polarized
reflectivity factor}
\item{"\code{PHIDP}"}{Differential phase (degrees)}
\item{"\code{ZDR}"}{(Logged) differential reflectivity (dB)}
}
The scan parameters are named according to the OPERA data information
model (ODIM), see Table 16 in the
\href{https://github.com/adokter/vol2bird/blob/master/doc/OPERA2014_O4_ODIM_H5-v2.2.pdf}{ODIM specification}.
}
\examples{
# load an example scan:
data(example_scan)

# print to screen the available scan parameters
summary(example_scan)

# make ppi for the scan
# plot the reflectivity param:
plot(example_scan, param = "DBZH")
\dontrun{
# change the range of reflectivities to plot, from -10 to 10 dBZ:
plot(example_scan, param = "DBZH", zlim = c(-10, 10))

# change the scale name and colour scheme, using viridis colors:
plot(example_scan, param = "DBZH", zlim = c(-10, 10)) + viridis::scale_fill_viridis(name = "dBZ")
}
}
