% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_pvolfiles.R
\name{download_pvolfiles}
\alias{download_pvolfiles}
\title{Download polar volume (\code{pvol}) files from the NEXRAD archive}
\usage{
download_pvolfiles(
  date_min,
  date_max,
  radar,
  directory = ".",
  overwrite = FALSE,
  bucket = "noaa-nexrad-level2"
)
}
\arguments{
\item{date_min}{POSIXct. Start date of file selection. If no timezone are
provided, it will be assumed to be UTC.}

\item{date_max}{POSIXct. End date of file selection.If no timezone are
provided, it will be assumed to be UTC.}

\item{radar}{character (vector). 4-letter radar code(s) (e.g. "KAMA")}

\item{directory}{character. Path to local directory where files should be
downloaded}

\item{overwrite}{logical. TRUE for re-downloading and overwriting previously
downloaded files of the same names.}

\item{bucket}{character. Bucket name to use.}
}
\description{
Download a selection of polar volume (\code{pvol}) files from the
\href{https://registry.opendata.aws/noaa-nexrad/}{NEXRAD Level II archive
data}.
}
\examples{
\dontrun{
dir.create("~/bioRad_tmp_files")
download_pvolfiles(
  date_min = as.POSIXct("2016-10-02 20:00", tz = "UTC"),
  date_max = as.POSIXct("2016-10-02 20:05", tz = "UTC"),
  radar = "KBBX",
  directory = "~/bioRad_tmp_files",
  overwrite = TRUE
)
}
}
