% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.vp.R
\name{plot.vp}
\alias{plot.vp}
\title{Plot a vertical profile (\code{vp})}
\usage{
\method{plot}{vp}(
  x,
  quantity = "dens",
  xlab = expression("volume density [#/km"^3 * "]"),
  ylab = "height [km]",
  line_col = "red",
  line_lwd = 1,
  line.col = "red",
  line.lwd = 1,
  ...
)
}
\arguments{
\item{x}{A \code{vp} class object.}

\item{quantity}{Character string with the quantity to plot. See
\link[=summary.vp]{vp} for list of available quantities.
\itemize{
\item{Aerial density related:}{'\code{dens}', '\code{eta}', '\code{dbz}',
'\code{DBZH}' for density, reflectivity, reflectivity factor and total
reflectivity factor, respectively.}
\item{Ground speed related:}{'\code{ff}','\code{dd}', for ground speed
and direction, respectively.}
}}

\item{xlab}{A title for the x axis.}

\item{ylab}{A title for the y axis.}

\item{line_col}{Color of the plotted curve.}

\item{line_lwd}{Line width of the plotted curve.}

\item{line.col}{Deprecated argument, use line_col instead.}

\item{line.lwd}{Deprecated argument, use line_lwd instead.}

\item{...}{Additional arguments to be passed to the low level
\link[graphics]{plot} plotting function.}
}
\description{
Plot a vertical profile (\code{vp})
}
\examples{
# load example vp object:
data(example_vp)

# plot the animal density:
plot(example_vp, quantity = "dens")

# change the line color:
plot(example_vp, line_col = "blue")

# plot the ground speed:
plot(example_vp, quantity = "ff")

# plot the reflectivity factor of
# all scatterers (including precipitation):
plot(example_vp, quantity = "DBZH")
}
