% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binspp_auxiliary.R
\name{plot_outputs}
\alias{plot_outputs}
\title{Graphical output describing the posterior distributions}
\usage{
plot_outputs(Output)
}
\arguments{
\item{Output}{list, output of the main function \code{\link[=estintp]{estintp()}}.}
}
\value{
Series of plots providing a graphical representation
of the posterior distributions in terms of histograms and
trace plots.
}
\description{
A graphical representation of the posterior distributions
in terms of histograms and trace plots.
}
\details{
If the covariate list \emph{z_beta} was non-empty, the estimated
intensity function of the parent process is plotted. Then,
the estimated surface representing the location dependent
mean number of points in a cluster is plotted, and similarly,
the estimated surface representing the location dependent scale
of clusters is plotted. \cr
After that, histograms of the sample posterior distributions
of the individual parameters are plotted, together with
the histograms of p-values giving significance of the individual
covariates in \emph{z_beta} with respect to the population
of parent points. \cr
Then, the trace plots for individual model parameters are plotted,
with highlighted sample median (full red line) and sample 2.5\%
and 97.5\% quantiles (dashed red lines), and similarly for
the p-values giving significance of the individual covariates
in \emph{z_beta} with respect to the population of parent points.
\cr
Additionally, the following graphs are also plotted:
\itemize{
\item trace plot for the log-likelihood of the model,
\item trace plot for the number of parent points,
\item trace plot for the probability of accepting proposed updates of \eqn{(alpha, alpha_1, …, alpha_l)}, \emph{}
\item trace plot for the fraction of accepted updates of \eqn{alpha, alpha_1, …, alpha_l} in the last 1000 iterations,
\item trace plot for the probability of accepting proposed updates of \eqn{omega, omega_1, …, omega_m}, \emph{}
\item trace plot for the fraction of accepted updates of \eqn{omega, omega_1, …, omega_m} in the last 1000 iterations,
\item trace plot for the fraction of accepted updates of parent points in the last 1000 iterations.
}
}
\examples{

library(spatstat)
# Prepare the dataset:
X = trees_N4
x_left = x_left_N4
x_right = x_right_N4
y_bottom = y_bottom_N4
y_top = y_top_N4

z_beta = list(refor = cov_refor, slope = cov_slope)
z_alpha = list(tmi = cov_tmi, tdensity = cov_tdensity)
z_omega = list(slope = cov_slope, reserv = cov_reserv)

# Determine the union of rectangles:
W = owin(c(x_left[1], x_right[1]), c(y_bottom[1], y_top[1]))
if (length(x_left) >= 2) {
  for (i in 2:length(x_left)) {
    W2 = owin(c(x_left[i], x_right[i]), c(y_bottom[i], y_top[i]))
    W = union.owin(W, W2)
  }
}

# Dilated observation window:
W_dil = dilation.owin(W, 100)


# Default parameters for prior distributions:
control = list(NStep = 100, BurnIn = 20, SamplingFreq = 5)


# MCMC estimation:
Output = estintp(X, control, x_left, x_right, y_bottom, y_top, W_dil,
                 z_beta, z_alpha, z_omega, verbose = FALSE)

# Text output + series of figures:
print_outputs(Output)
plot_outputs(Output)

}
